<?php
http_response_code(200);

// ۱. استخراج IP کاربر
if (!empty($_SERVER['HTTP_CLIENT_IP'])){
    $ip = $_SERVER['HTTP_CLIENT_IP'];
} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
    $ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
} elseif (!empty($_SERVER['HTTP_X_REAL_IP'])){
    $ip = $_SERVER['HTTP_X_REAL_IP'];
} elseif (!empty($_SERVER['HTTP_AR_REAL_IP'])){
    $ip = $_SERVER['HTTP_AR_REAL_IP'];
} else {
    $ip = $_SERVER['REMOTE_ADDR'];
} 

if (!empty($_SERVER['SCRIPT_URI'])){
    $url = $_SERVER['SCRIPT_URI'];
} elseif (!empty($_SERVER['HTTP_HOST'])){
    $url = 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'];
}
$url = rtrim($url, 'index.php');

// ۲. تابع بررسی دقیق IP تلگرام (تبدیل به عدد Long)
function is_telegram_ip($ip) {
    $ip_long = ip2long(trim($ip));
    if ($ip_long === false) return false;
    
    // رنج آی‌پی‌های رسمی تلگرام
    $lower_1 = ip2long("149.154.160.0");
    $upper_1 = ip2long("149.154.175.255");
    $lower_2 = ip2long("91.108.4.0");
    $upper_2 = ip2long("91.108.7.255");
    
    return (($ip_long >= $lower_1 && $ip_long <= $upper_1) || ($ip_long >= $lower_2 && $ip_long <= $upper_2));
}

// اگر درخواست از سمت تلگرام نبود یا پروتکل HTTPS نبود، مسدود شود
if (!is_telegram_ip($ip)) {
    exit(header("Location: ".$url."bot_file/index.php"));
} elseif (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === "off" || $_SERVER['SERVER_PORT'] != 443) {
    exit(header("Location: ".$url."bot_file/index.php"));
}

// ۳. بررسی دقیق Secret Token
require_once 'config.php'; // لود کردن کانفیگ برای دسترسی به متغیر $sec_code
$received_token = isset($_SERVER['HTTP_X_TELEGRAM_BOT_API_SECRET_TOKEN']) ? $_SERVER['HTTP_X_TELEGRAM_BOT_API_SECRET_TOKEN'] : '';

// بررسی اینکه آیا MD5 توکن دریافتی با توکنی که در دیتابیس/کانفیگ داریم برابر است یا نه
if (empty($received_token) || md5($received_token) !== $sec_code) {
    exit(header("Location: ".$url."bot_file/index.php"));
}

// ادامه روال ذخیره و انتقال دیتای تلگرام
$data = file_get_contents('php://input');
$temp = "temp/up_".rand(0, 1000)."".time();
file_put_contents($temp, '');

// انتقال توکن تایید شده به فایل پردازشگر
$url .= 'bot_file/index.php?hash='.$received_token.'&temp='.$temp;
$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_POSTFIELDS          => $data,
    CURLOPT_TIMEOUT             => 50,
    CURLOPT_RETURNTRANSFER      => true,
    CURLOPT_SSL_VERIFYPEER      => false,
    CURLOPT_SSL_VERIFYHOST      => false,
    CURLOPT_CONNECTTIMEOUT_MS   => 50,
    CURLOPT_HTTPHEADER => [
        'accept: application/json',
        'content-type: application/json'
    ]
]);
curl_exec($ch);
curl_close($ch);
?>