<?php
 function deletedir($dirPath) {
    if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
        $dirPath .= '/';
    }
    $files = glob($dirPath . '*', GLOB_MARK);
    foreach ($files as $file) {
        if (is_dir($file)) {
            deletedir($file);
        } else {
            unlink($file);
        }
    }
    rmdir($dirPath);
}
function curl_get($url)
{
	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_TIMEOUT, 30);

	$resp = curl_exec($curl);
	$e = curl_errno($curl);
	curl_close($curl);
	if ($e) {
		$err = curl_error($curl);
		error_log("Curl Get Error : " . $err);
		return false;
	} else {
		return $resp;
	}
}
function curl_post($url, $data = [], $headers = array("Content-Type: application/json"))
{
	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_POST, true);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_TIMEOUT, 30);

	$headers = $headers;

	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

	$data = json_encode($data);

	curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

	$resp = curl_exec($curl);
	$e = curl_errno($curl);
	curl_close($curl);
	if ($e) {

		$err = curl_error($curl);
		error_log("Curl Post Error : " . $err);
		return false;
	} else {
		return $resp;
	}
}

function random_code($r=8)
{
$alf="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
$key="";
for($i=0;$i<$r;$i++){
$key.=$alf[rand(0,strlen($alf)-1)];
}
return $key;
}
function checktoken($token){
	$ex = explode(':',$token);
	if($ex !== null and is_numeric($ex[0]) and strlen($ex[1]) < 40 and strlen($token) >  10){
	return true;
	}else{
	return false;
	}
	}
function crtable($botdb,$admin){
    $botdb->create('files', [
		'code' => [
			'VARCHAR(500)','PRIMARY KEY'
		],
		'type' => [
			'VARCHAR(500)',
		],
		'data' => [
			'TEXT',
		],
		'download' => [
			'INT','NOT NULL',
		],
		'admin' => [
			'BIGINT','NOT NULL',
		],
		'date' => [
			'INT','NOT NULL',
		],
	], [
		'CHARSET'=>'utf8mb4'
	]);
	$botdb->create('sendall', [
		'id' => [
			'BIGINT','NOT NULL','PRIMARY KEY','AUTO_INCREMENT',
		],
		'step' => [
			'TEXT',
		],
		'data' => [
			'TEXT',
		],
		'user' => [
			'TEXT',
		],
		'admin' => [
			'TEXT',
		],
		'last' => [
			'INT','NOT NULL','DEFAULT 0'
		],
	], [
		'CHARSET'=>'utf8mb4'
	]);
	$botdb->create('settings', [
		'id' => [
			'BIGINT','NOT NULL','PRIMARY KEY','AUTO_INCREMENT',
		],
		'del_time' => [
			'INT','NOT NULL','DEFAULT 10'
		],
		'online' => [
			'INT','NOT NULL','DEFAULT 0'
		],
		'upuser' => [
			'INT','NOT NULL','DEFAULT 0'
		],
		'texts' => [
			'TEXT',
		],
		'admins' => [
			'TEXT',
		],
		'joins' => [
			'TEXT',
		],
		'ads' => [
			'TEXT',
		],
	], [
		'CHARSET'=>'utf8mb4'
	]);
	$botdb->create('users', [
		'id' => [
			'BIGINT','NOT NULL','PRIMARY KEY',
		],
		'step' => [
			'VARCHAR(500)','NOT NULL','DEFAULT 0',
		],
		'data' => [
			'text','NOT NULL',
		],
		'last_msg' => [
			'INT','NOT NULL','DEFAULT 0',
		],
		'msgblock' => [
			'INT','NOT NULL','DEFAULT 0',
		],
		'block' => [
			'INT','NOT NULL','DEFAULT 0',
		],
		'join_date' => [
			'INT','NOT NULL',
		],
		'online' => [
			'INT','NOT NULL','DEFAULT 1',
		],
	], [
		'CHARSET'=>'utf8mb4'
	]);
	$botdb->insert('users',['id'=>$admin,'join_date'=>time()]);
	$botdb->insert('settings',['id'=>1,'texts[JSON]'=>['start'=>"خوش آمدید.\nCLOCKEMOJI DATE TIME",'not_found'=>"فایل مورد نظر پاک شده یا وجود ندارد",'join'=>"کاربر گرامی، برای دریافت فایل ابتدا در کانال های زیر عضو شوید🔻",'del'=>"این پیام بعد از SLEEPTIME ثانیه پاک میشود.\nلطفا در جایی ذخیره کنید"]]);
	$botdb->insert('sendall',[['id'=>1,'step'=>'none','data'=>0,'user'=>0,'admin'=>0],['id'=>2,'step'=>'none','data'=>0,'user'=>0,'admin'=>0]]);
	return true;
}
?>